
import SwiftUI

struct ContentView: View {
   var body: some View {
      VStack {
         Text("Hello, world!")
            .padding()
         Button("Run Task") {
            Task {
               let imageName = await loadImage(name: "My Image")
               print(imageName)
               let text = await loadText()
               print(text)
            }
         }
      }
   }
   func loadImage(name: String) async -> String {
      try? await Task.sleep(for: .seconds(5))
      return "Name: \(name)"
   }
   func loadText() async -> String {
      try? await Task.sleep(for: .seconds(2))
      return "This is from loadText()"
   }
}

#Preview {
    ContentView()
}
